<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;

/**
 * Round
 *
 * @ORM\Table(name="rounds")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\RoundRepository")
 *
 * @ExclusionPolicy("all")
 */
class Round
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage", "list"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_group_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage"})
     */
    private $userGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage", "list"})
     */
    private $name;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="start_at", type="datetime", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage"})
     * @Type("DateTime<'Y-m-d H:i:s'>")
     */
    private $startAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="end_at", type="datetime", nullable=true)
     */
    private $endAt;


    /**
     * @var integer
     *
     * @ORM\Column(name="market", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage"})
     */
    private $market = 0;


    /**
     * @var integer
     *
     * @ORM\Column(name="sequence", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"manage"})
     */
    private $sequence;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_counting", type="boolean")
     */
    private $isCounting = false;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_done", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage"})
     */
    private $isDone = false;


    /**
     * @ORM\ManyToOne(targetEntity="UserGroups", inversedBy="rounds")
     * @ORM\JoinColumn(name="user_group_id", referencedColumnName="id")
     */
    protected $group;

    /**
     * @ORM\OneToMany(targetEntity="CompanyAllegroCategoryItem", mappedBy="round")
     */
    protected $places;

    /**
     * @ORM\OneToMany(targetEntity="SummaryRoundBankServiceOption", mappedBy="round")
     */
    protected $summaryRoundBankServiceOption;

    /**
     * @ORM\OneToMany(targetEntity="SummaryCompanyRound", mappedBy="round")
     */
    protected $summaryCompanyRound;

    /**
     * @ORM\OneToMany(targetEntity="CompanyOfferReport", mappedBy="round")
     */
    protected $roundReports;

    /**
     * @ORM\OneToMany(targetEntity="CompanyBankServiceOption", mappedBy="round")
     */
    protected $companyBankServiceOptions;

    /**
     * @ORM\OneToMany(targetEntity="AccountChange", mappedBy="round")
     */
    protected $accountChanges;

    /**
     * @ORM\OneToMany(targetEntity="CompanyOffer", mappedBy="round")
     */
    protected $roundOffers;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Round
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set startAt
     *
     * @param \DateTime $startAt
     * @return Round
     */
    public function setStartAt($startAt)
    {
        $this->startAt = $startAt;
    
        return $this;
    }

    /**
     * Get startAt
     *
     * @return \DateTime 
     */
    public function getStartAt()
    {
        return $this->startAt;
    }

    /**
     * Set endAt
     *
     * @param \DateTime $endAt
     * @return Round
     */
    public function setEndAt($endAt)
    {
        $this->endAt = $endAt;
    
        return $this;
    }

    /**
     * Get endAt
     *
     * @return \DateTime 
     */
    public function getEndAt()
    {
        return $this->endAt;
    }

    /**
     * Set market
     *
     * @param integer $market
     * @return Round
     */
    public function setMarket($market)
    {
        $this->market = $market;
    
        return $this;
    }

    /**
     * Get market
     *
     * @return integer 
     */
    public function getMarket()
    {
        return $this->market;
    }

    /**
     * Set sequence
     *
     * @param integer $sequence
     * @return Round
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
    
        return $this;
    }

    /**
     * Get sequence
     *
     * @return integer 
     */
    public function getSequence()
    {
        return $this->sequence;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->places = new \Doctrine\Common\Collections\ArrayCollection();
        $this->summaryRoundBankServiceOption = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add places
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places
     * @return Round
     */
    public function addPlace(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places)
    {
        $this->places[] = $places;
    
        return $this;
    }

    /**
     * Remove places
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places
     */
    public function removePlace(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places)
    {
        $this->places->removeElement($places);
    }

    /**
     * Get places
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlaces()
    {
        return $this->places;
    }

    /**
     * Add summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     * @return Round
     */
    public function addSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption[] = $summaryRoundBankServiceOption;
    
        return $this;
    }

    /**
     * Remove summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     */
    public function removeSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption->removeElement($summaryRoundBankServiceOption);
    }

    /**
     * Get summaryRoundBankServiceOption
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSummaryRoundBankServiceOption()
    {
        return $this->summaryRoundBankServiceOption;
    }

    /**
     * Add summaryCompanyRound
     *
     * @param \VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound
     * @return Round
     */
    public function addSummaryCompanyRound(\VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound)
    {
        $this->summaryCompanyRound[] = $summaryCompanyRound;
    
        return $this;
    }

    /**
     * Remove summaryCompanyRound
     *
     * @param \VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound
     */
    public function removeSummaryCompanyRound(\VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound)
    {
        $this->summaryCompanyRound->removeElement($summaryCompanyRound);
    }

    /**
     * Get summaryCompanyRound
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSummaryCompanyRound()
    {
        return $this->summaryCompanyRound;
    }

    /**
     * Add roundReports
     *
     * @param \VM\ApiBundle\Entity\CompanyReport $roundReports
     * @return Round
     */
    public function addRoundReport(\VM\ApiBundle\Entity\CompanyReport $roundReports)
    {
        $this->roundReports[] = $roundReports;
    
        return $this;
    }

    /**
     * Remove roundReports
     *
     * @param \VM\ApiBundle\Entity\CompanyReport $roundReports
     */
    public function removeRoundReport(\VM\ApiBundle\Entity\CompanyReport $roundReports)
    {
        $this->roundReports->removeElement($roundReports);
    }

    /**
     * Get roundReports
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getRoundReports()
    {
        return $this->roundReports;
    }

    /**
     * Add companyBankServiceOptions
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOptions
     * @return Round
     */
    public function addCompanyBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOptions)
    {
        $this->companyBankServiceOptions[] = $companyBankServiceOptions;
    
        return $this;
    }

    /**
     * Remove companyBankServiceOptions
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOptions
     */
    public function removeCompanyBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOptions)
    {
        $this->companyBankServiceOptions->removeElement($companyBankServiceOptions);
    }

    /**
     * Get companyBankServiceOptions
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyBankServiceOptions()
    {
        return $this->companyBankServiceOptions;
    }

    /**
     * Add accountChanges
     *
     * @param \VM\ApiBundle\Entity\AccountChange $accountChanges
     * @return Round
     */
    public function addAccountChange(\VM\ApiBundle\Entity\AccountChange $accountChanges)
    {
        $this->accountChanges[] = $accountChanges;
    
        return $this;
    }

    /**
     * Remove accountChanges
     *
     * @param \VM\ApiBundle\Entity\AccountChange $accountChanges
     */
    public function removeAccountChange(\VM\ApiBundle\Entity\AccountChange $accountChanges)
    {
        $this->accountChanges->removeElement($accountChanges);
    }

    /**
     * Get accountChanges
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAccountChanges()
    {
        return $this->accountChanges;
    }

    /**
     * Set isCounting
     *
     * @param boolean $isCounting
     * @return Round
     */
    public function setIsCounting($isCounting)
    {
        $this->isCounting = $isCounting;
    
        return $this;
    }

    /**
     * Get isCounting
     *
     * @return boolean 
     */
    public function getIsCounting()
    {
        return $this->isCounting;
    }

    /**
     * Set isDone
     *
     * @param boolean $isDone
     * @return Round
     */
    public function setIsDone($isDone)
    {
        $this->isDone = $isDone;
    
        return $this;
    }

    /**
     * Get isDone
     *
     * @return boolean 
     */
    public function getIsDone()
    {
        return $this->isDone;
    }

    /**
     * Add roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     * @return Round
     */
    public function addRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers[] = $roundOffers;
    
        return $this;
    }

    /**
     * Remove roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     */
    public function removeRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers->removeElement($roundOffers);
    }

    /**
     * Get roundOffers
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getRoundOffers()
    {
        return $this->roundOffers;
    }

    /**
     * Set userGroupId
     *
     * @param integer $userGroupId
     * @return Round
     */
    public function setUserGroupId($userGroupId)
    {
        $this->userGroupId = $userGroupId;
    
        return $this;
    }

    /**
     * Get userGroupId
     *
     * @return integer 
     */
    public function getUserGroupId()
    {
        return $this->userGroupId;
    }

    /**
     * Set group
     *
     * @param \VM\ApiBundle\Entity\UserGroups $group
     * @return Round
     */
    public function setGroup(\VM\ApiBundle\Entity\UserGroups $group = null)
    {
        $this->group = $group;
    
        return $this;
    }

    /**
     * Get group
     *
     * @return \VM\ApiBundle\Entity\UserGroups 
     */
    public function getGroup()
    {
        return $this->group;
    }
}